/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import com.pfg.mi1robot.Comandos;
import com.pfg.mi1robot.Escenario;
import com.pfg.mi1robot.Robot;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.IOException;

public class Speed
extends Comandos {
    private int velocidad;
    private Bitmap graficonum;

    public Speed(int X, int Y, Bitmap grafico) {
        this.setNombre("Velocidad");
        this.setTipo("Flujo");
        this.setX(X);
        this.setY(Y);
        this.grafico = grafico;
        this.graficonum = null;
    }

    public void setSpeed(int velocidad, Bitmap graficonum) {
        this.velocidad = velocidad;
        this.graficonum = graficonum;
    }

    public int getSpeed() {
        return this.velocidad;
    }

    @Override
    public void draw(Graphics g, int xcord, int ycord) {
        g.drawImage(this.grafico.getImagen(), this.getX() - xcord, this.getY() - ycord, null);
        if (this.graficonum != null) {
            g.drawImage(this.graficonum.getImagen(), this.getX() - xcord + this.grafico.getWidth(), this.getY() - ycord, null);
        }
    }

    @Override
    public void exec(Robot robot, Escenario escenario) {
        robot.setVelocidad(this.velocidad);
    }

    @Override
    public Comandos clone() {
        return new Speed(this.getX(), this.getY(), this.grafico);
    }

    @Override
    public void loadSound() {
    }

    @Override
    public void save(BufferedWriter writer) throws IOException {
        writer.write("Velocidad " + this.velocidad);
    }
}

